﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using UUN;
using System.Data.SqlClient;
using System.IO;
using System.Text;
using System.Text.RegularExpressions;
using System.Xml;

public partial class Admin_NeiRong_WenZhangCaiJi_LanMu_PiRuKu : System.Web.UI.Page
{
    private 访问 访问;
    protected void Page_Load(object sender, EventArgs e)
    {
        访问 = new 访问(this.Context);
        访问.开始处理("批量采集入库", "网站后台", "批量采集入库", new 访问.回调委托(ZhiXing));
        访问.关闭连接();
    }

    private void ZhiXing()
    {
        访问.验证管理员();

        if (this.IsPostBack)
            入库();
        else
            初始化();
    }

    private void 入库()
    {
        访问.验证权限("10");
        if (SuoShuFenLei.SelectedValue == null || SuoShuFenLei.SelectedValue == "")
            throw new Exception("请选择分类");

        int ID = Convert.ToInt32(Request.QueryString["ID"]);
        String[] WIDS = Request.QueryString["WID"].Split(new char[] { ',' }, StringSplitOptions.RemoveEmptyEntries);
        String 当前地址 = Request.QueryString["url"];
        Hashtable 采集栏目 = 常用.SQL_获取(new SqlCommand("SELECT * FROM [" + 程序.数据表前缀 + "内容_文章采集_栏目] WHERE [ID]=" + ID, 访问.连接));
        if (采集栏目 == null)
            throw new Exception("采集栏目不存在");
        Server.ScriptTimeout = 99999999;

        int 网站ID = Convert.ToInt32(采集栏目["所属网站"]);
        当前时间 = DateTime.Now;

        int 所属分类 = Convert.ToInt32(SuoShuFenLei.SelectedValue);
        String 文章来源 = WenZhangLaiYuan.Text;
        String 文章作者 = ZuoZhe.Text;
        String 标题样式_颜色 = BianTiYangShi_YanSe.Text;
        bool 标题样式_粗体 = BiaoTiYangShi_ChuTi.Checked;
        bool 标题样式_斜体 = BiaoTiYangShi_XieTi.Checked;
        bool 标题样式_删除线 = BiaoTiYangShi_ShanChuXian.Checked;
        bool 是否推荐 = ShiFouTuiJian.Checked;
        bool 是否关闭评论 = GuanBiPingLun.Checked;
        bool 是否UBB = UBBNeiRong.Checked;
        bool 是否保存图片 = BaoCunTuPian.Checked;
        bool 是否手动分页 = ShouDongFenYe.Checked;
        int 内容模板 = Convert.ToInt32(NeiRongMoBan.SelectedValue);
        int 内容模板_3G = Convert.ToInt32(NeiRongMoBan_3G.SelectedValue);
        int 评论模板 = Convert.ToInt32(PingLunMoBan.SelectedValue);
        int 评论模板_3G = Convert.ToInt32(PingLunMoBan_3G.SelectedValue);
        bool 权限_仅限会员 = QuanXian_JinXianHuiYuan.Checked;
        int 权限_需要等级 = Convert.ToInt32(QuanXian_XuYaoDenJi.Text);
        int 权限_扣除积分 = Convert.ToInt32(QuanXian_KouChuJiFen.Text);

        Response.Write("<style type=\"text/css\">body{font-size:12px}</style>");

        文章采集 文章采集 = new 文章采集(this.Context, 访问.连接, 网站ID);
        Hashtable 标题地址;
        String 网页内容=文章采集.获取网页内容(当前地址);
        文章采集.获取标题和地址(当前地址, 网页内容,
            Convert.ToBoolean(采集栏目["标题和地址_是否通配符"]),
            Convert.ToString(采集栏目["标题和地址_表达式"]),
            out 标题地址);


        int i = 1;
        foreach (int 键 in 标题地址.Keys)
        {
            if (是否存在ID(WIDS, i))
            {
                String[] 数组=(String[])标题地址[键];
                if(GuoLvChongFu.Checked)
                    if (是否重复信息(数组[1]))
                    {
                        输出内容("正在跳过数据：" + Server.HtmlEncode(数组[1]));
                        continue;
                    }

                输出内容("正在采集文章：" + Server.HtmlEncode(数组[1]));
                输出内容("正在获取数据：<a href=\"" + Server.HtmlEncode(数组[0]) + "\" target=\"_blank\">" + Server.HtmlEncode(数组[0]) + "</a>");

                String 资源文件 = "";
                String 文章内容 = 文章采集.获取文章内容(数组[0],
                    Convert.ToBoolean(采集栏目["文章内容_是否通配符"]),
                    Convert.ToString(采集栏目["文章内容_表达式"]),
                    Convert.ToBoolean(采集栏目["文章下页_是否通配符"]),
                    Convert.ToString(采集栏目["文章下页_表达式"]),
                    Convert.ToString(采集栏目["内容过滤"]));

                int ZGID = 常用.SQL_最高ID(访问.连接, 程序.数据表前缀 + "内容_文章_文章");
                if (是否保存图片)
                    文章内容 = 保存网络图片_UBB(文章内容,
                        "\\(img\\)(?<url>.+?)\\(/img\\)",
                        ZGID, ref 资源文件);

                输出内容("正在保存文章：" + Server.HtmlEncode(数组[1]));

                String 文件夹位置 = "~/Data/DT_WenZhang/" + (ZGID /500) + "/";
                if (!Directory.Exists(Server.MapPath(文件夹位置)))
                    Directory.CreateDirectory(Server.MapPath(文件夹位置));
                String 图片位置 = "~/Data/DT_WenZhang/IMG_" + (ZGID /500) + "/";
                if(!Directory.Exists(Server.MapPath(图片位置)))
                    Directory.CreateDirectory(Server.MapPath(图片位置));

                File.WriteAllText(Server.MapPath(文件夹位置 + ZGID + ".txt"),
                    文章内容, Encoding.UTF8);
                SqlCommand 语句 = new SqlCommand("INSERT INTO [" + 程序.数据表前缀 + "内容_文章_文章]" +
                    "([ID],[所属栏目],[标题],[标题样式_粗体],[标题样式_斜体],[标题样式_删除线],[标题样式_颜色],[是否推荐],[是否审核],[是否删除],[外部链接],[发布时间],[作者],[文章来源],[文章简介],[是否手动分页],[是否UBB],[是否关闭评论],[内容模板],[3G内容模板],[评论模板],[3G评论模板],[权限_仅限会员],[权限_需要等级],[权限_扣除积分],[文件资源])" +
                    "VALUES(@ID,@所属栏目,@标题,@标题样式_粗体,@标题样式_斜体,@标题样式_删除线,@标题样式_颜色,@是否推荐,@是否审核,@是否删除,@外部链接,@发布时间,@作者,@文章来源,@文章简介,@是否手动分页,@是否UBB,@是否关闭评论,@内容模板,@3G内容模板,@评论模板,@3G评论模板,@权限_仅限会员,@权限_需要等级,@权限_扣除积分,@文件资源)", 访问.连接);
                语句.Parameters.Add("@ID", SqlDbType.Int).Value = ZGID;
                语句.Parameters.Add("@所属栏目", SqlDbType.Int).Value = 所属分类;
                语句.Parameters.Add("@标题", SqlDbType.NVarChar).Value = 数组[1];
                语句.Parameters.Add("@标题样式_粗体", SqlDbType.Bit).Value = 标题样式_粗体;
                语句.Parameters.Add("@标题样式_斜体", SqlDbType.Bit).Value = 标题样式_斜体;
                语句.Parameters.Add("@标题样式_删除线", SqlDbType.Bit).Value = 标题样式_删除线;
                语句.Parameters.Add("@标题样式_颜色", SqlDbType.NVarChar).Value = 标题样式_颜色;
                语句.Parameters.Add("@是否推荐", SqlDbType.Bit).Value = 是否推荐;
                语句.Parameters.Add("@是否审核", SqlDbType.Bit).Value = !访问.是否包含权限("46");
                语句.Parameters.Add("@是否删除", SqlDbType.Bit).Value = false;
                语句.Parameters.Add("@外部链接", SqlDbType.NVarChar).Value = "";
                语句.Parameters.Add("@发布时间", SqlDbType.DateTime).Value = 当前时间;
                语句.Parameters.Add("@作者", SqlDbType.NVarChar).Value = 文章作者;
                语句.Parameters.Add("@文章来源", SqlDbType.NVarChar).Value = 文章来源;
                语句.Parameters.Add("@文章简介", SqlDbType.NVarChar).Value = 常用.截取字符串(文章内容, Convert.ToInt32(程序.设置["内容设置_自动文章简介字符数"]));
                语句.Parameters.Add("@是否手动分页", SqlDbType.Bit).Value = 是否手动分页;
                语句.Parameters.Add("@是否UBB", SqlDbType.Bit).Value = 是否UBB;
                语句.Parameters.Add("@是否关闭评论", SqlDbType.Bit).Value = 是否关闭评论;
                语句.Parameters.Add("@内容模板", SqlDbType.Int).Value = 内容模板;
                语句.Parameters.Add("@3G内容模板", SqlDbType.Int).Value = 内容模板_3G;
                语句.Parameters.Add("@评论模板", SqlDbType.Int).Value = 评论模板;
                语句.Parameters.Add("@3G评论模板", SqlDbType.Int).Value = 评论模板_3G;
                语句.Parameters.Add("@权限_仅限会员", SqlDbType.Bit).Value = 权限_仅限会员;
                语句.Parameters.Add("@权限_需要等级", SqlDbType.Int).Value = 权限_需要等级;
                语句.Parameters.Add("@权限_扣除积分", SqlDbType.Int).Value = 权限_扣除积分;
                语句.Parameters.Add("@文件资源", SqlDbType.NVarChar).Value = 资源文件;
                语句.ExecuteNonQuery();

                if (DaoXuCaiJi.Checked)
                    当前时间 = 当前时间 - new TimeSpan(0, 0, 1);
            }
            i++;
        }

        Response.Write("<script type=\"text/javascript\">window.close();</script>");
    }
    private bool 是否重复信息(String 标题)
    {
        bool 返回值;
        SqlCommand 语句 = new SqlCommand("SELECT [ID] FROM [" + 程序.数据表前缀 + "内容_文章_文章] WHERE [标题]=@标题", 访问.连接);
        语句.Parameters.Add("@标题", SqlDbType.NVarChar).Value = 标题;
        SqlDataReader 读取 = 语句.ExecuteReader();
        返回值 = 读取.HasRows;
        读取.Close();

        return 返回值;
    }
    /// <summary>
    /// 将文章里的图片保存到本地
    /// </summary>
    /// <param name="文章正文">文章正文的内容</param>
    /// <param name="_表达式">获取图片地址的表达式</param>
    /// <param name="ID">文章的ID</param>
    /// <param name="资源文件">保存在本地的位置</param>
    /// <returns></returns>
    public String 保存网络图片_UBB(String 文章正文, String _表达式, int ID, ref String 资源文件)
    {
        Regex 表达式 = new Regex(_表达式);
        MatchCollection JGS = 表达式.Matches(文章正文);
        for (int i = 0; i < JGS.Count; i++)
        {
            Match JG = JGS[i];
            String 地址 = JG.Groups["url"].Value;
            String 后缀 = Path.GetExtension(地址).Substring(1);
            if (地址.StartsWith("http://", StringComparison.OrdinalIgnoreCase) && 常用.是否允许后缀("gif,jpg,jpe,jpeg,png,tif,tiff,bmp", 后缀))
            {
                输出内容("正在下载图片：" + Server.HtmlEncode(地址));
                String 随机值 = "T" + ID + 常用.随机字符(30);
                String 文件名 = 程序.安装位置 + "Data/DT_WenZhang/IMG_" + (ID /500) + "/" + 随机值 + "." + 后缀;
                常用.下载文件(地址, Server.MapPath(文件名));
                文章正文 = 文章正文.Replace(JG.Value, "[img]" + 文件名 + "[/img]");
                资源文件 += 资源文件 == "" ? "" : ",";
                资源文件 += 文件名;
            }
        }
        return 文章正文;
    }
    private int 信息位置 = 0;
    private DateTime 当前时间;
    private void 输出内容(String 信息内容)
    {
        Response.Write("<a name=\"w" + 信息位置 + "\">_</a>");
        Response.Write(信息内容);
        Response.Write("<br/>");
        Response.Write(@"<script type=""text/javascript"">
location.href='#w" + 信息位置 + @"';
</script>");
        Response.Flush();
        信息位置++;
    }

    private bool 是否存在ID(String[] IDS, int ID)
    {
        bool 返回值 = false;
        for (int i = 0; i < IDS.Length; i++)
            if (IDS[i] == ID.ToString())
                返回值 = true;

        return 返回值;
    }

    private void 初始化()
    {
        DataSet 数据 = new DataSet();
        SqlCommand 语句 = new SqlCommand("SELECT [ID],[栏目名称],[所属栏目],[是否拥有子栏目] FROM [" + 程序.数据表前缀 + "内容_栏目] WHERE [栏目类型]='文章'", 访问.连接);
        SqlDataAdapter 填充 = new SqlDataAdapter(语句);
        填充.Fill(数据, "内容栏目");

        生成列表(数据, 0, 1);
        NeiRongMoBan.Items.Add(new ListItem("默认模板", "0"));
        NeiRongMoBan_3G.Items.Add(new ListItem("默认模板", "0"));
        PingLunMoBan.Items.Add(new ListItem("默认模板", "0"));
        PingLunMoBan_3G.Items.Add(new ListItem("默认模板", "0"));

        FileInfo[] FIS = new DirectoryInfo(Server.MapPath("~/Template/Content/" + 程序.设置["默认模板"] + "/Content/")).GetFiles();

        for (int i = 0; i < FIS.Length; i++)
        {
            int ID = 0;
            String 模板名称 = "";
            String 模板类型 = "";
            String _内容类型 = "";
            bool 是否WAP = true;

            XmlReader 读取 = XmlReader.Create(FIS[i].OpenRead());
            while (读取.Read())
                if (读取.NodeType == XmlNodeType.Element)
                    if (读取.Name == "set")
                        if (读取.GetAttribute("name") == "ID")
                            ID = Convert.ToInt32(读取.GetAttribute("value"));
                        else if (读取.GetAttribute("name") == "模板名称")
                            模板名称 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "模板类型")
                            模板类型 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "内容类型")
                            _内容类型 = 读取.GetAttribute("value");
                        else if (读取.GetAttribute("name") == "是否WAP")
                            是否WAP = Convert.ToBoolean(读取.GetAttribute("value"));
            读取.Close();

            if (_内容类型 == "文章")
                switch (模板类型)
                {
                    case "查看内容":
                        if (是否WAP)
                            NeiRongMoBan.Items.Add(new ListItem(模板名称, ID.ToString()));
                        else
                            NeiRongMoBan_3G.Items.Add(new ListItem(模板名称, ID.ToString()));
                        break;
                    case "评论列表":
                        if (是否WAP)
                            PingLunMoBan.Items.Add(new ListItem(模板名称, ID.ToString()));
                        else
                            PingLunMoBan_3G.Items.Add(new ListItem(模板名称, ID.ToString()));
                        break;
                }
        }
    }

    private void 生成列表(DataSet 数据, int 父栏目, int 深度)
    {
        for (int i = 0; i < 数据.Tables[0].Rows.Count; i++)
        {
            DataRow 行 = 数据.Tables[0].Rows[i];
            if (Convert.ToInt32(行["所属栏目"]) == 父栏目)
            {
                ListItem 列表项 = new ListItem(生成空格(深度) + Convert.ToString(行["栏目名称"]), Convert.ToString(行["ID"]));
                列表项.Attributes["style"] = Convert.ToBoolean(行["是否拥有子栏目"]) ? "" : "background:#eeeeee";
                SuoShuFenLei.Items.Add(列表项);
                生成列表(数据, Convert.ToInt32(行["ID"]), 深度 + 1);
            }
        }
    }

    private String 生成空格(int 数量)
    {
        String 返回值 = "";
        for (int i = 0; i < 数量; i++)
            返回值 += "　";
        return 返回值 + "|-";
    }
}
